/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.orderform.screen.GeneralServerInfoScreen;
import net.creeperhost.minetogether.orderform.screen.MapScreen;
import net.creeperhost.minetogether.orderform.screen.OrderDetailsScreen;
import net.creeperhost.minetogether.orderform.screen.PersonalDetailsScreen;
import net.creeperhost.minetogether.orderform.screen.QuoteScreen;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class OrderServerScreen
extends Screen {
    private static final int STEP_AMOUNT = 5;
    protected final int stepId;
    protected final Order order;
    protected Button buttonPrev;
    protected Button buttonNext;
    protected Button buttonCancel;
    private Screen parent;

    public OrderServerScreen(int stepId, Screen parent, Order order) {
        super((Component)new TranslatableComponent("minetogether.screen.orderscreen"));
        this.stepId = stepId;
        this.order = order;
        this.parent = parent;
    }

    public OrderServerScreen(int stepId, Order order) {
        super((Component)new TranslatableComponent("minetogether.screen.orderscreen"));
        this.stepId = stepId;
        this.order = order;
    }

    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.addNavigationButtons();
    }

    public void addNavigationButtons() {
        this.buttonPrev = new Button(10, this.f_96544_ - 30, 80, 20, (Component)new TranslatableComponent("minetogether.button.prev"), button -> this.f_96541_.m_91152_(OrderServerScreen.getByStep(this.stepId - 1, this.order, this.parent)));
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.buttonCancel = new Button(this.f_96543_ / 2 - 40, this.f_96544_ - 30, 80, 20, (Component)new TranslatableComponent("minetogether.button.cancel"), button -> this.cancelOrder());
        this.m_142416_((GuiEventListener)this.buttonCancel);
        this.buttonCancel.f_93624_ = this.stepId != 4;
        this.buttonNext = new Button(this.f_96543_ - 90, this.f_96544_ - 30, 80, 20, (Component)new TranslatableComponent("minetogether.button.next"), button -> {
            if (this.stepId + 1 == 5) {
                this.f_96541_.m_91152_(this.parent);
            } else {
                this.f_96541_.m_91152_(OrderServerScreen.getByStep(this.stepId + 1, this.order, this.parent));
            }
        });
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev.f_93623_ = this.stepId > 0;
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        OrderServerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (String)("Step " + (this.stepId + 1) + " / 5"), (int)(this.f_96543_ - 30), (int)10, (int)-1);
        OrderServerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (String)this.getStepName(), (int)(this.f_96543_ / 2), (int)10, (int)-1);
        super.m_6305_(poseStack, i, j, f);
    }

    public static Screen getByStep(int step, Order order, Screen parent) {
        switch (step) {
            default: {
                return new GeneralServerInfoScreen(0, order, parent);
            }
            case 1: {
                return new MapScreen(1, order);
            }
            case 2: {
                return new PersonalDetailsScreen(2, order);
            }
            case 3: {
                return new QuoteScreen(3, order);
            }
            case 4: 
        }
        return new OrderDetailsScreen(4, order);
    }

    public abstract String getStepName();

    public void cancelOrder() {
        this.f_96541_.m_91152_(null);
    }
}

